<?php 
	//seguridad base
	session_start();

	if(!isset($_SESSION['id_usuario'])){
		header("Location: index.php");
		die();
	}

	//seguridad extra
	if($_SESSION['tipo_usuario'] != 'A') {
		header("Location: en_vivo.php");
		die();
	}
 ?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		
		<title> THOMSON REUTERS | ARGENTINA </title>
		
		<link rel="stylesheet" href="libs/bootstrap-3.3.7-dist/css/bootstrap.min.css">
		<link rel="stylesheet" href="libs/bootstrap-3.3.7-dist/css/bootstrap-theme.min.css">
		
		<!-- Datatable CSS -->
		<link rel="stylesheet" type="text/css" href="libs/DataTables-1.10.11/css/dataTables.bootstrap.min.css"/>
		
		<script src="libs/jquery-1.12.4.min.js" type="text/javascript"></script>
		<script src="libs/bootstrap-3.3.7-dist/js/bootstrap.min.js" type="text/javascript"></script>

		<!-- Datatable JS -->
		<script type="text/javascript" src="libs/DataTables-1.10.11/js/jquery.dataTables.min.js"></script>
		<script type="text/javascript" src="libs/DataTables-1.10.11/js/dataTables.bootstrap.min.js"></script>
		
		<!-- Datatable CS TableTools -->
		<link rel="stylesheet" href="libs/DataTables-1.10.11/extensions/TableTools/css/dataTables.tableTools.min.css">

		<!-- Datatable JS TableTools -->
		<script type="text/javascript" src="libs/DataTables-1.10.11/extensions/TableTools/js/dataTables.tableTools.min.js"></script>
		

		
		<style type="text/css" media="screen">

			/*Preparar pantalla*/
			html, body{
				height: 100%;
			}
			
				
			

			/*Reglas importantes*/

			@font-face {
				font-family: Knowledge-Light;
				src: url(recursos/FONT/Knowledge-Light.ttf);
			}
			@font-face {
				font-family: Knowledge-Regular;
				src: url(recursos/FONT/Knowledge-Regular.ttf);
			}
			@font-face {
				font-family: Montserrat-Light;
				src: url(recursos/FONT/Montserrat-Light.otf);
			}
			*, body{
				font-family: "Arial" ;
			}
			.navbar{
				min-height: 80px;
			}
			#logo_navbar{
				margin-top: 7px;
				margin-left: 55px;
				width: 370px;
			}

			#body{
				margin-top: 20px;
			}

			.archivo{
				margin-bottom: 30px
			}

			.archivo .texto-naranja{
				margin-top: 6px;
			}

			.archivo .texto-gris{
				margin-top: 4px;
			}
			.archivo .texto-azul{
				margin-top: 8px;
			}

			#titulo_evento{
				font-size: 40px;
				color: #555555;
				font-family: Knowledge-Light;
				margin-top: 15px;
			}
			.navbar-default .navbar-nav > .active > a, 
			.navbar-default .navbar-nav > .active > a:focus, 
			.navbar-default .navbar-nav > .active > a:hover{
				background: none;
				box-shadow: none;
				color: #FF6C0C;
				text-decoration: underline;
				
			}

			.navbar-nav > li > a{
				font-family: Knowledge-Regular;
			}

			#btn-buscar{
				background: none;
				border: none;
				padding: 0px; 
			}
			#div_pregunta{
				margin-top: 20px;
			}
			#div_pregunta label{
				color: #999;
				font-weight: normal;
			}
			#div_archivo{
				margin-top: 20px;
			}

			#pregunta{
				height: 100px;
				width: 100%;
				resize: none;
				border: 1px solid #cccc;

			}

			hr{
				border-top-color: #646569;
			}
			#eventos_anteriores{
				margin-bottom: 10px;
			}
			#eventos_anteriores p {
				margin-top: 15px;
				font-size: 15px;

			}
			#footer{
				background-color: #555555;
				height: 40px;
				font-family: Montserrat-Light;
				color: #B3B3B3;
				font-size: 11px;
				width: 100%;
				text-align: center;
				
			}

			.pagination > li > a{
				border:none;
				font-size: 16px;
				font-weight: bold;
				color: #555555;
			}	

			
			.pagination > .active > a,
			.pagination > .active > a:focus,
			.pagination > .active > a:hover{
				background: none;
				color: #FF6C0C;
			}
			#body{
				min-height: calc(100% - 202px);
			}

			/* Estilo esclusivo celular */
			@media (max-width: 767px) { 
				.navbar{
					min-height: 50px;
				}
				#logo_navbar{
					margin-top: -1px;
					margin-left: 0px;
					width: 228px;
				}
				
				#footer{
					margin-top: 100px;
					padding-top: 6px;
				}
				#body{
					min-height: calc(100% - 212px);
				}
			}
	
			/* Estilo resolucion mayor a un celular */
			@media (min-width: 768px) { 
				#menu{
					margin-right: 25px;
					font-size: 15px
				}
				.navbar-nav > li > a{
					padding-top: 30px;
					padding-bottom: 30px;
				}

				#footer{
					/*position: fixed;
					bottom: 0;*/
					padding-top:13px; 
					margin-top: 60px;
				}
			}
			
	
			/* Clases asistentes */
			.texto-naranja{
				color: #FF6C0C;
			}
			.texto-gris{
				color: #555555;
			} 
			.texto-azul{
				color: #0099C4;
			}

			.bold{
				font-weight: bold;
			}

			.px16{
				font-size: 16px;
			}
			.px15{
				font-size: 15px;	
			}
			.input{
				width: 100%;
				border-top: none;
				border-right: none;
				border-left: none;
				border-bottom: 1px solid #cccc;
				padding: 7px 0px;
				margin-bottom: 3px;
				margin-top: 7px;
			}
			.input:placeholder{
				color: #999;
			}
			.wrapper {
				
				width: 100%;
				/* whatever width you want */
				display: inline-block;
				position: relative;
			}
			.wrapper:after {
				padding-top: 56.25%;
				/* 16:9 ratio */
				display: block;
				content: '';
			}
			.main {
			    position: absolute;
			    top: 0;
			    bottom: 0;
			    right: 0;
			    left: 0;
			    background-color: black;
			    color: white;
			}
			.progress-big{
				height: 40px !important;
			}
			.progress-big > div{
				font-size: 30px;
				line-height: 37px;
			}
			#tabla_usuarios_length{
				height: 45px;
			}
		</style>
		<script type="text/javascript">

			var id_usuario 			= 0;
			var accion_formulario 	= "registrar";

			var html_cargando 	= 	'<div class="progress progress-big">'+
									  '<div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%">'+
									    'Cargando...<span class="sr-only">100% Complete</span>'+
									  '</div>'+
									'</div>';

			var html_procesando = 	'<div class="progress progress-big">'+
									  '<div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%">'+
									    'Procesando...<span class="sr-only">100% Complete</span>'+
									  '</div>'+
									'</div>';

		
			$(document).ready(function() {

				$('#ventana_usuarios').on('hidden.bs.modal', function (e) {
					$('#form_usuarios')[0].reset();
					$('#mensaje_usuario').html("");
					$('#btn-enviar').html("Registrar");
					accion_formulario = "registrar";

				});

				$('#form_usuarios').on('submit', function(event) {
					event.preventDefault();
					/* Act on the event */

					$('#mensaje_usuario').html(html_procesando);
					$('#btn-enviar').prop("disabled",true);

					var url = "php/registrar/registrar_usuario.php";
					if(accion_formulario != "registrar"){
						url = "php/actualizar/actualizar_usuario.php";
					}
					$.post(url, $('#form_usuarios').serialize()+"&id_usuario="+id_usuario , function(data, textStatus, xhr) {
						if(data.resultado == "1"){
							//todo salio bien
							
							if(accion_formulario == "registrar"){
								$('#mensaje_usuario').html("<div class='alert alert-success'> Registro exitoso.</div>");
							}else{
								$('#mensaje_usuario').html("<div class='alert alert-success'> Actualización exitosa.</div>");
							}
							id_usuario = data.mensaje;
							accion_formulario = "actualizar";
							$('#btn-enviar').html("Actualizar");
							actualizar_tabla_usuario();
						}else{
							$('#mensaje_usuario').html("<div class='alert alert-danger'>"+data.mensaje+"</div>");
						}
					},'json').fail(function(){
						$('#mensaje_usuario').html("<div class='alert alert-danger'> Error en la comunicación, verifique su conexión a Internet.</div>");
					}).always(function(){
						$('#btn-enviar').prop("disabled",false);
					});


					return false;
				});

				//inicia ejecucion
				actualizar_tabla_usuario();
			
			});

			function actualizar_tabla_usuario(){
				$('#contenedor_tabla_usuarios').html(html_cargando);
				$.post('tablas/tabla_usuarios.php', function(data, textStatus, xhr) {
					$('#contenedor_tabla_usuarios').html(data);

					$('.editar_usuario').click(function(event) {
						var datos 	= $(this).parent().parent();

						id_usuario 	= datos.data("id"); 
						var correo 	= datos.data("correo"); 
						var pass 	= datos.data("pass"); 
						
						$('#correo').val(correo);
						$('#pass').val(pass);
						
						accion_formulario = "actualizar";
						$('#btn-enviar').html("Actualizar");

						$('#ventana_usuarios').modal("show");
						
					});

					$('.eliminar_usuario').click(function(event) {
						var datos 	= $(this).parent().parent();

						id_usuario 	= datos.data("id"); 
						var correo 	= datos.data("correo"); 

						
						var respuesta = confirm("¿Desea eliminar la cuenta de correo: "+correo+"?");
						if(respuesta === true){
							$('#contenedor_tabla_usuarios').html(html_procesando);

							$.post('php/eliminar/eliminar_usuario.php', {id_usuario: id_usuario}, function(data, textStatus, xhr) {
								if(data == "1"){
									actualizar_tabla_usuario();
								}else{
									alert(data);
								}
							}).fail(function(){
								alert("Error en la comunicación, verifique su conexión a Internet");
							});
						}
					});

					$('#tabla_usuarios').DataTable({
						"dom": 'Tl<"clear">frtip',
				        tableTools: {
				            "sSwfPath": "libs/DataTables-1.10.11/extensions/TableTools/swf/copy_csv_xls_pdf.swf"
				        },			
						"order": [],
						"language": {
						    "sProcessing":     "Procesando...",
						    "sLengthMenu":     "Mostrar _MENU_ registros",
						    "sZeroRecords":    "No se encontraron resultados",
						    "sEmptyTable":     "Ningún dato disponible en esta tabla",
						    "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
						    "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0 registros",
						    "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
						    "sInfoPostFix":    "",
						    "sSearch":         "Buscar:",
						    "sUrl":            "",
						    "sInfoThousands":  ",",
						    "sLoadingRecords": "Cargando...",
						    "oPaginate": {
						        "sFirst":    "Primero",
						        "sLast":     "Último",
						        "sNext":     "Siguiente",
						        "sPrevious": "Anterior"
						    },
						    "oAria": {
						        "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
						        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
						    }
						}
					});
				}).fail(function(){
					$('#contenedor_tabla_usuarios').html("<div class='alert alert-danger'> Error en la comunicación, verifique su conexión a Internet.</div>");
				});
			}


		</script>
	</head>
	<body>
		<nav class="navbar navbar-default">
		  	<div class="container-fluid">
		    	<!-- Brand and toggle get grouped for better mobile display -->
		    	<div class="navbar-header">
			      	
			      	<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-collapse-en-vivo" aria-expanded="false">
			        	<span class="sr-only">Toggle navigation</span>
			        	<span class="icon-bar"></span>
			        	<span class="icon-bar"></span>
			        	<span class="icon-bar"></span>
			      	</button>
					
			      	<a class="navbar-brand" href="index.php">
			      		<img alt="Thimsin Reuters" src="recursos/logo.png" id="logo_navbar">
			      	</a>
		    	</div>

		    	<div class="collapse navbar-collapse" id="navbar-collapse-en-vivo">
	      			
	      			<ul class="nav navbar-nav navbar-right" id="menu" >
	        			<li class="active"><a href="registro_usuarios.php">USUARIOS</a></li>
	        			<li><a href="php/cerrar_sesion.php">LOGOUT</a></li>
	      			</ul>
	    		</div><!-- /.navbar-collapse -->
	
		  	</div><!-- /.container-fluid -->
		</nav>
		
		<div class="container" id="body">
			<div class="row">
				<div class="col-sm-12">
					<h1 id="titulo_evento"> Usuarios registrados </h1>
				</div>
				<div class="col-sm-12">
					<button class="btn btn-primary" data-toggle="modal" data-target="#ventana_usuarios"> Registrar usuario </button>
				</div>
				<div class="col-sm-12" id="contenedor_tabla_usuarios" style="margin-top: 15px;"></div>
			</div>	
		</div>

		<!-- Ventanas -->
		<div id="ventana_usuarios" class="modal fade" data-backdrop="static" tabindex="-1" role="dialog">
	  		<div class="modal-dialog modal-sm" role="document">
	    		<div class="modal-content">
		      		<div class="modal-header">
		        		<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		        		<h4 class="modal-title">Registro de usuarios</h4>
		      		</div>
		      		<form id="form_usuarios">
			      		<div class="modal-body">
			        		<div class="row">
	          					<div class="col-sm-12">
									<div class="form-group">
									    <label for="correo">Correo</label>
									    <input type="text" class="form-control" id="correo" name="correo" required="">
									</div>
								</div>
								<div class="col-sm-12">
									<div class="form-group">
									    <label for="pass">Contraseña</label>
									    <input type="text" class="form-control" id="pass" name="pass" required="">
									</div>
	          					</div>
	          					<div class="col-sm-12" id="mensaje_usuario"></div>
					        </div>
			      		</div>
			      		<div class="modal-footer">
			        		<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
			        		<button type="submit" class="btn btn-primary" id="btn-enviar">Registrar</button>
			      		</div>
		      		</form>
	    		</div><!-- /.modal-content -->
	  		</div><!-- /.modal-dialog -->
		</div><!-- /.modal -->

		<div class="container-fluid" id="footer">
			<!-- Licencia: www.diabetes.org.ar <span class="hidden-xs">| </span> <br class="visible-xs-block">  Streaming: www.livedirecto.com -->
			Licencia: www.thomsonreuters.com.ar <span class="hidden-xs">| </span> <br class="visible-xs-block"> Streaming: www.livedirecto.com
		</div>
	</body>
</html>